<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="">Pilih Petugas</label>
                                <select name="" id="petugas" class="form-control">
                                    <option value="">Pilih</option>
                                    <option value="All">All Petugas </option>
                                    @foreach ($user as $u)
                                        <option value="{{ $u->id }}">{{ $u->nm_user }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="">Dari Tanggal</label>
                                <input type="date" name="" id="tgl1" class="form-control"
                                    value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-md-3">
                                <label for="">Sampai Tanggal</label>
                                <input type="date" name="" id="tgl2" class="form-control"
                                    value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-primary cari" style="margin-top: 32px;"><i
                                        class="fa fa-search "></i> </button>

                                <button class="btn btn-dark cetak" style="margin-top: 32px;"><i
                                        class="fa fa-print "></i></button>

                                <button class="btn btn-success export" style="margin-top: 32px;"><i
                                        class="fa fa-file-excel mr-1"></i> E-excel!</button>
                            </div>
                        </div>
                        <hr>
                        <hr>

                        <div id="hidedata">
                            <div id="print">
                                <div class="tampil_data"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script>
            $('.cari').click(function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var petugas = $('#petugas').val();
                var tgl1 = $('#tgl1').val();
                var tgl2 = $('#tgl2').val();

                if (petugas == "") {
                    Toast.fire({
                        icon: "error",
                        title: "Silahakn pilih petugas !",
                    });
                } else {
                    $.ajax({
                        type: 'POST',
                        url: "lap-stok",
                        data: {
                            petugas: petugas,
                            tgl1: tgl1,
                            tgl2: tgl2,
                            _token: token,
                        },
                        beforeSend: function() {
                            $('.cari').html('<i class="fas fa-spinner fa-spin"></i>');
                            $('.cari').attr("disabled", true);
                        },
                        success: function(data) {
                            $('.tampil_data').html(data);
                            $('.cari').html('<i class="fa fa-search "></i> ');
                            $('.cari').attr("disabled", false);

                        }
                    });
                }
            });

            $('.export').click(function() {
                var petugas = $('#petugas').val();
                var tgl1 = $('#tgl1').val();
                var tgl2 = $('#tgl2').val();
                var token = $("meta[name='csrf-token']").attr("content");

                if (petugas == "") {
                    Toast.fire({
                        icon: "error",
                        title: "Silahakn pilih petugas !",
                    });
                } else {
                    $.ajax({
                        type: 'POST',
                        url: 'export-lap-stok',
                        data: {
                            petugas: petugas,
                            tgl1: tgl1,
                            tgl2: tgl2,
                            _token: token,
                        },
                        beforeSend: function() {
                            $('.export').html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $('.export').attr("disabled", true);
                        },
                        success: function(data) {
                            document.location.href = "download/stok";
                            $('.export').html(
                                '<i class="fas  fa-file mr-2"></i> E-excel!'
                            );
                            $('.export').attr("disabled", false);
                        }
                    })
                }
            });

            $('.cetak').click(function() {
                $("#hidedata").hide();
                printPageArea("print");
                document.location.href = "";
            })

            function printPageArea(areaID) {
                var printContent = document.getElementById(areaID).innerHTML;
                var originalContent = document.body.innerHTML;
                document.body.innerHTML = printContent;
                window.print();
                document.body.innerHTML = originalContent;
            }
        </script>
    </x-slot:foot>
</x-admin.contents>
